<?php include_once('includes/head.php'); ?>
    <style>
        .metric-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-left: 4px solid;
            height: 100%;
        }
        .metric-card.revenue { border-left-color: #10b981; }
        .metric-card.agents { border-left-color: #3b82f6; }
        .metric-card.bets { border-left-color: #f59e0b; }
        .metric-card.payouts { border-left-color: #ef4444; }
        .metric-card.active { border-left-color: #8b5cf6; }
        .metric-card.commission { border-left-color: #06b6d4; }
        
        .metric-value {
            font-size: 24px;
            font-weight: 700;
            margin: 10px 0 5px 0;
        }
        .metric-label {
            color: #6b7280;
            font-size: 14px;
            font-weight: 500;
        }
        .metric-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            margin-bottom: 10px;
        }
        .metric-card.revenue .metric-icon { background: #10b981; color: white; }
        .metric-card.agents .metric-icon { background: #3b82f6; color: white; }
        .metric-card.bets .metric-icon { background: #f59e0b; color: white; }
        .metric-card.payouts .metric-icon { background: #ef4444; color: white; }
        .metric-card.active .metric-icon { background: #8b5cf6; color: white; }
        .metric-card.commission .metric-icon { background: #06b6d4; color: white; }
        
        .admin-action-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 15px;
            color: white;
            font-size: 14px;
            font-weight: 600;
            text-align: center;
            display: block;
            width: 100%;
            text-decoration: none;
            transition: transform 0.2s ease;
            margin-bottom: 10px;
        }
        .admin-action-btn:hover {
            transform: translateY(-2px);
            color: white;
            text-decoration: none;
        }
        .admin-action-btn.secondary {
            background: #6b7280;
        }
        .admin-action-btn.danger {
            background: #ef4444;
        }
        
        .winning-numbers {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
            margin-top: 10px;
        }
        .winning-number {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #8b5cf6;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 12px;
        }
        
        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        .status-active { background: #d1fae5; color: #065f46; }
        .status-inactive { background: #fee2e2; color: #991b1b; }
        .status-pending { background: #fef3c7; color: #92400e; }
        .status-suspended { background: #e5e7eb; color: #374151; }
        
        .system-alert {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
            border: 2px solid #f59e0b;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .alert-header {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        .alert-icon {
            color: #d97706;
            margin-right: 10px;
            font-size: 1.2rem;
        }
        
        .quick-stats {
            background: #f8fafc;
            border-radius: 10px;
            padding: 15px;
            margin: 10px 0;
        }
        .stat-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e2e8f0;
        }
        .stat-row:last-child {
            border-bottom: none;
        }
        
        .admin-section {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border: 1px solid #e3ebf6;
        }
        .section-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
    </style>

<body class="nk-body bg-light has-sidebar">
    <!-- Top Navigation -->
   <?php include_once('includes/head.php'); ?>

    <!-- Sidebar -->
   <?php include_once('includes/sidebar.php'); ?>

    <!-- Main Content -->
    <div class="nk-wrap">
        <div class="nk-content">
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="nk-block-head">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Admin Dashboard</h3>
                            <div class="nk-block-des text-soft">
                                <p>System overview and administrative controls</p>
                            </div>
                        </div>
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="pageMenu">
                                    <em class="icon ni ni-more-v"></em>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- System Alert -->
                <div class="system-alert">
                    <div class="alert-header">
                        <i class="fas fa-exclamation-triangle alert-icon"></i>
                        <strong>System Notice</strong>
                    </div>
                    <p class="mb-0">3 new agent applications pending review. Next scheduled draw in 2 hours.</p>
                </div>

                <!-- Key Metrics Cards -->
                <div class="nk-block">
                    <div class="row g-gs">
                        <div class="col-sm-6 col-lg-4">
                            <div class="metric-card revenue">
                                <div class="metric-icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                                <div class="metric-value">₦ 245,800.00</div>
                                <div class="metric-label">Total Revenue</div>
                                <div class="quick-stats">
                                    <div class="stat-row">
                                        <span>Today:</span>
                                        <span>₦ 12,450.00</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>This Week:</span>
                                        <span>₦ 87,200.00</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4">
                            <div class="metric-card agents">
                                <div class="metric-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="metric-value">127</div>
                                <div class="metric-label">Total Agents</div>
                                <div class="quick-stats">
                                    <div class="stat-row">
                                        <span>Active:</span>
                                        <span>118</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>Pending:</span>
                                        <span>3</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4">
                            <div class="metric-card bets">
                                <div class="metric-icon">
                                    <i class="fas fa-ticket-alt"></i>
                                </div>
                                <div class="metric-value">8,742</div>
                                <div class="metric-label">Total Bets Today</div>
                                <div class="quick-stats">
                                    <div class="stat-row">
                                        <span>5/90:</span>
                                        <span>5,231</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>6/90:</span>
                                        <span>2,874</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="col-sm-6 col-lg-4">
                            <div class="metric-card payouts">
                                <div class="metric-icon">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </div>
                                <div class="metric-value">₦ 89,500.00</div>
                                <div class="metric-label">Total Payouts</div>
                                <div class="quick-stats">
                                    <div class="stat-row">
                                        <span>Pending:</span>
                                        <span>₦ 15,200.00</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>Processed:</span>
                                        <span>₦ 74,300.00</span>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                        <!-- <div class="col-sm-6 col-lg-4">
                            <div class="metric-card active">
                                <div class="metric-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <div class="metric-value">94.2%</div>
                                <div class="metric-label">System Uptime</div>
                                <div class="quick-stats">
                                    <div class="stat-row">
                                        <span>This Month:</span>
                                        <span>99.8%</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>Incidents:</span>
                                        <span>2</span>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                        <!-- Agent Commission card removed per admin preference -->
                    </div>
                </div>

                <!-- Quick Actions & System Overview -->
                <div class="nk-block">
                    <div class="row g-gs">
                        <!-- Quick Actions Column -->
                        <div class="col-lg-4">
                            <div class="admin-section">
                                <h6 class="section-title">
                                    <i class="fas fa-bolt"></i>
                                    Quick Actions
                                </h6>
                                <a href="draw-management.html" class="admin-action-btn">
                                    <i class="fas fa-play-circle me-2"></i>
                                    Start New Draw
                                </a>
                                <a href="results-management.html" class="admin-action-btn">
                                    <i class="fas fa-trophy me-2"></i>
                                    Declare Results
                                </a>
                                <a href="agent-approvals.html" class="admin-action-btn">
                                    <i class="fas fa-user-check me-2"></i>
                                    Review Agent Applications
                                </a>
                                <!-- Process Payouts, System Backup and System Settings removed per request -->
                            </div>

                            <!-- System Status -->
                            <div class="admin-section">
                                <h6 class="section-title">
                                    <i class="fas fa-server"></i>
                                    System Status
                                </h6>
                                <div class="quick-stats">
                                    <div class="stat-row">
                                        <span>Database:</span>
                                        <span class="status-badge status-active">Online</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>Payment Gateway:</span>
                                        <span class="status-badge status-active">Online</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>API Services:</span>
                                        <span class="status-badge status-active">Online</span>
                                    </div>
                                    <div class="stat-row">
                                        <span>Backup System:</span>
                                        <span class="status-badge status-pending">Pending</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Recent Draw Results -->
                            <div class="admin-section">
                                <h6 class="section-title">
                                    <i class="fas fa-trophy"></i>
                                    Last Draw Result
                                </h6>
                                <div class="text-center">
                                    <div class="fw-bold mb-2">Draw #D28761 - 5/90</div>
                                    <div class="winning-numbers justify-content-center">
                                        <span class="winning-number">12</span>
                                        <span class="winning-number">45</span>
                                        <span class="winning-number">78</span>
                                        <span class="winning-number">23</span>
                                        <span class="winning-number">56</span>
                                    </div>
                                    <div class="mt-3">
                                        <small class="text-muted">Declared: Nov 10, 2024 20:05</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Recent Activity & Pending Actions -->
                        <div class="col-lg-8">
                            <!-- Pending Actions -->
                            <div class="admin-section">
                                <div class="card-title-group">
                                    <div class="card-title">
                                        <h6 class="title">Pending Actions</h6>
                                    </div>
                                    <div class="card-tools">
                                        <a href="alerts.html" class="link">View All</a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Action Type</th>
                                                <th>Details</th>
                                                <th>Priority</th>
                                                <th>Created</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Agent Approval</td>
                                                <td>3 new agent applications</td>
                                                <td><span class="status-badge status-pending">High</span></td>
                                                <td>2 hours ago</td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary">Review</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Payout Processing</td>
                                                <td>₦ 15,200 in pending payouts</td>
                                                <td><span class="status-badge status-pending">Medium</span></td>
                                                <td>4 hours ago</td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary">Process</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>System Backup</td>
                                                <td>Weekly backup overdue</td>
                                                <td><span class="status-badge status-pending">Medium</span></td>
                                                <td>1 day ago</td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary">Run Backup</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Draw Management</td>
                                                <td>Next draw in 2 hours</td>
                                                <td><span class="status-badge status-pending">Low</span></td>
                                                <td>6 hours ago</td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary">Prepare</button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Recent Agent Activity -->
                            <div class="admin-section">
                                <div class="card-title-group">
                                    <div class="card-title">
                                        <h6 class="title">Recent Agent Activity</h6>
                                    </div>
                                    <div class="card-tools">
                                        <a href="agents-list.html" class="link">View All Agents</a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Agent ID</th>
                                                <th>Name</th>
                                                <th>Activity</th>
                                                <th>Bets Today</th>
                                                <th>Status</th>
                                                <th>Last Active</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>#A2876</td>
                                                <td>John Smith</td>
                                                <td>Placed 24 bets</td>
                                                <td>₦ 1,280.50</td>
                                                <td><span class="status-badge status-active">Active</span></td>
                                                <td>15 min ago</td>
                                            </tr>
                                            <tr>
                                                <td>#A2875</td>
                                                <td>Sarah Wilson</td>
                                                <td>Processed payouts</td>
                                                <td>₦ 890.00</td>
                                                <td><span class="status-badge status-active">Active</span></td>
                                                <td>30 min ago</td>
                                            </tr>
                                            <tr>
                                                <td>#A2874</td>
                                                <td>Mike Johnson</td>
                                                <td>New agent registration</td>
                                                <td>₦ 0.00</td>
                                                <td><span class="status-badge status-pending">Pending</span></td>
                                                <td>2 hours ago</td>
                                            </tr>
                                            <tr>
                                                <td>#A2873</td>
                                                <td>Lisa Brown</td>
                                                <td>Suspended for review</td>
                                                <td>₦ 0.00</td>
                                                <td><span class="status-badge status-suspended">Suspended</span></td>
                                                <td>1 day ago</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="/loto/public/assets/js/bundle9b70.js?ver=3.3.0"></script>
    <script src="/loto/public/assets/js/scripts9b70.js?ver=3.3.0"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>
        // Admin dashboard functionality + live API wiring via axios
        document.addEventListener('DOMContentLoaded', function() {
            axios.defaults.withCredentials = true; // include session cookie

            // Helper to normalize list responses from different API shapes
            function normalizeList(res) {
                if (!res) return [];
                if (Array.isArray(res)) return res;
                if (res.data) {
                    if (Array.isArray(res.data)) return res.data;
                    if (Array.isArray(res.data.message)) return res.data.message;
                    if (Array.isArray(res.data.data)) return res.data.data;
                }
                return [];
            }

            /* ---------- Agents ---------- */
            async function loadAgents() {
                try {
                    const res = await axios.get('/loto/api/agent/list');
                    const agents = normalizeList(res) || [];

                    // Locate Recent Agent Activity section
                    const heading = Array.from(document.querySelectorAll('.card-title .title')).find(h => h.textContent && h.textContent.trim() === 'Recent Agent Activity');
                    let section = heading ? heading.closest('.admin-section') : null;
                    if (!section) {
                        const byTitle = Array.from(document.querySelectorAll('.section-title')).find(h => h.textContent && h.textContent.includes('Recent Agent Activity'));
                        if (byTitle) section = byTitle.closest('.admin-section');
                    }
                    if (!section) return;
                    const tbody = section.querySelector('tbody');
                    if (!tbody) return;

                    tbody.innerHTML = '';
                    agents.forEach(function (a) {
                        const id = a.agent_id ?? a.id ?? a.user_id ?? '';
                        const name = (a.first_name || a.last_name) ? ((a.first_name||'') + ' ' + (a.last_name||'')).trim() : (a.name ?? a.fullname ?? a.userName ?? a.email ?? '');
                        const activity = a.last_action ?? a.activity ?? '-';
                        const bets = a.bets_today ?? a.total_bets ?? a.bet_count ?? '-';
                        const statusRaw = a.status ?? a.is_active ?? a.state ?? null;
                        const statusText = (statusRaw === 'active' || statusRaw === '1' || statusRaw === 1 || statusRaw === true) ? 'Active' : (statusRaw === 'suspended' ? 'Suspended' : 'Pending');
                        const statusClass = statusText === 'Active' ? 'status-active' : (statusText === 'Suspended' ? 'status-suspended' : 'status-pending');
                        const lastActive = a.last_active ?? a.updated_at ?? a.last_login ?? '-';

                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${id}</td>
                            <td>${name}</td>
                            <td>${activity}</td>
                            <td>${bets}</td>
                            <td><span class="status-badge ${statusClass}">${statusText}</span></td>
                            <td>${lastActive}</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary admin-agent-edit" data-id="${id}">Edit</button>
                                <button class="btn btn-sm btn-outline-danger admin-agent-delete" data-id="${id}">Delete</button>
                            </td>
                        `;
                        tbody.appendChild(tr);
                    });

                    // attach handlers (use event delegation for safety)
                    tbody.querySelectorAll('.admin-agent-delete').forEach(btn => {
                        btn.addEventListener('click', function(){
                            const id = this.dataset.id;
                            if (!confirm('Delete agent ' + id + '?')) return;
                            axios.post('/loto/api/agent/delete', { id: id })
                                .then(r => { loadAgents(); updateAdminMetrics(); loadPendingActions(); })
                                .catch(e => { console.error(e); alert('Failed to delete agent'); });
                        });
                    });

                    tbody.querySelectorAll('.admin-agent-edit').forEach(btn => {
                        btn.addEventListener('click', function(){
                            const id = this.dataset.id;
                            const field = prompt('Field to update (e.g. userName, email, phone):');
                            if (!field) return;
                            const value = prompt('New value for ' + field + ':');
                            if (value === null) return;
                            const payload = {};
                            payload[field] = value;
                            axios.post('/loto/api/agent/update', Object.assign({ id: id }, payload))
                                .then(r => { loadAgents(); updateAdminMetrics(); })
                                .catch(e => { console.error(e); alert('Failed to update agent'); });
                        });
                    });
                } catch (err) {
                    console.error('Error fetching agents:', err);
                }
            }

            /* ---------- Winners / Results ---------- */
            async function loadLastResult() {
                try {
                    const res = await axios.get('/loto/api/winner/list');
                    const winners = normalizeList(res);
                    if (!winners || !winners.length) return;
                    const w = winners[0]; // latest

                    const heading = Array.from(document.querySelectorAll('.section-title')).find(h => h.textContent && h.textContent.includes('Last Draw Result'));
                    const section = heading ? heading.closest('.admin-section') : null;
                    if (!section) return;

                    const drawInfo = section.querySelector('.fw-bold') || section.querySelector('div');
                    if (drawInfo) drawInfo.textContent = w.draw_id ? ('Draw #' + (w.draw_id || w.id) + ' - ' + (w.draw_type ?? w.game_type ?? 'Result')) : ('Draw - Result');

                    const numbersContainer = section.querySelector('.winning-numbers');
                    if (numbersContainer) {
                        numbersContainer.innerHTML = '';
                        const nums = Array.isArray(w.numbers) ? w.numbers : (Array.isArray(w.winning_numbers) ? w.winning_numbers : (('' + (w.numbers || w.winning_numbers || '')).split(/[ ,]+/).filter(Boolean)));
                        nums.forEach(n => {
                            const span = document.createElement('span');
                            span.className = 'winning-number';
                            span.textContent = n;
                            numbersContainer.appendChild(span);
                        });
                    }
                    const dateEl = section.querySelector('small.text-muted');
                    if (dateEl) dateEl.textContent = w.created_at ?? w.declared_at ?? w.updated_at ?? '';
                } catch (e) {
                    console.error('Error loading winners', e);
                }
            }

            /* ---------- Metrics & Status ---------- */
            async function updateAdminMetrics() {
                try {
                    const [agentsRes, ticketsRes, winnersRes] = await Promise.all([
                        axios.get('/loto/api/agent/list').catch(()=>({data:{}})),
                        axios.get('/loto/api/ticket/list').catch(()=>({data:{}})),
                        axios.get('/loto/api/winner/list').catch(()=>({data:{}}))
                    ]);

                    const agents = normalizeList(agentsRes);
                    const tickets = normalizeList(ticketsRes);
                    const winners = normalizeList(winnersRes);

                    const agentCount = agents.length;
                    const ticketCount = tickets.length;

                    // compute revenue (sum ticket.amount or total_amount)
                    let revenue = 0;
                    let pendingPayouts = 0;
                    tickets.forEach(t => {
                        const amt = parseFloat(t.amount ?? t.total_amount ?? t.price ?? 0) || 0;
                        revenue += amt;
                        const status = (t.status || t.state || '').toString().toLowerCase();
                        if (status === 'pending' || status === 'unpaid') pendingPayouts += amt;
                    });

                    const winnersCount = winners.length;
                    const commissionDue = winnersCount * 100; // heuristic

                    // compute active / pending agent counts
                    let activeCount = 0, pendingCount = 0;
                    agents.forEach(a => {
                        const st = (a.status ?? a.is_active ?? a.state ?? '').toString().toLowerCase();
                        if (st === 'active' || st === '1' || st === 'true' || st === 'yes') activeCount++;
                        else pendingCount++;
                    });

                    // Update metric cards and quick-stats where present
                    document.querySelectorAll('.metric-card').forEach(card => {
                        const labelEl = card.querySelector('.metric-label');
                        const valueEl = card.querySelector('.metric-value');
                        if (!labelEl || !valueEl) return;
                        const label = labelEl.textContent.trim();
                        if (label === 'Total Agents') {
                            valueEl.textContent = agentCount;
                            // update quick-stats rows (Active / Pending)
                            const qs = card.querySelector('.quick-stats');
                            if (qs) {
                                qs.querySelectorAll('.stat-row').forEach(row => {
                                    const key = (row.querySelector('span:first-child')?.textContent || '').trim();
                                    const valEl = row.querySelector('span:last-child');
                                    if (!key || !valEl) return;
                                    if (key.toLowerCase().startsWith('active')) valEl.textContent = activeCount;
                                    if (key.toLowerCase().startsWith('pending')) valEl.textContent = pendingCount;
                                });
                            }
                        }
                        if (label === 'Total Bets Today') valueEl.textContent = ticketCount;
                        if (label === 'Total Revenue') valueEl.textContent = '₦ ' + revenue.toFixed(2);
                        if (label === 'Total Payouts') valueEl.textContent = '₦ ' + pendingPayouts.toFixed(2);
                        if (label === 'Agent Commission Due') valueEl.textContent = '₦ ' + commissionDue.toFixed(2);
                    });
                } catch (err) {
                    console.error('Error updating metrics', err);
                }
            }

            // System notice (pending agents and next draw)
            async function loadSystemNotice() {
                try {
                    const [agentsRes, drawsRes] = await Promise.all([
                        axios.get('/loto/api/agent/list').catch(()=>({data:{}})),
                        axios.get('/loto/api/draw/list').catch(()=>({data:{}}))
                    ]);
                    const agents = normalizeList(agentsRes);
                    const draws = normalizeList(drawsRes);

                    const pendingAgents = agents.filter(a => {
                        const st = (a.status ?? a.is_active ?? '').toString().toLowerCase();
                        return st === 'pending' || st === '0' || st === 'new';
                    }).length;

                    const nextDraw = (Array.isArray(draws) && draws.length) ? draws[draws.length - 1] : null;
                    const nextText = nextDraw ? (nextDraw.draw_date ?? nextDraw.draw_datetime ?? nextDraw.draw_time ?? '') : 'N/A';

                    const alert = document.querySelector('.system-alert p');
                    if (alert) {
                        alert.textContent = `${pendingAgents} new agent application(s) pending review. Next scheduled draw: ${nextText || 'TBD'}.`;
                    }
                } catch (e) { console.warn('loadSystemNotice failed', e); }
            }

            // Pending Actions table
            async function loadPendingActions() {
                try {
                    const tbody = Array.from(document.querySelectorAll('.admin-section .table-responsive')).find(el => {
                        const title = el.closest('.admin-section')?.querySelector('.card-title .title');
                        return title && title.textContent && title.textContent.trim() === 'Pending Actions';
                    });
                    const tableBody = tbody ? tbody.querySelector('tbody') : null;
                    if (!tableBody) return;
                    tableBody.innerHTML = '';

                    const agentsRes = await axios.get('/loto/api/agent/list').catch(()=>({data:{}}));
                    const ticketsRes = await axios.get('/loto/api/ticket/list').catch(()=>({data:{}}));
                    const agents = normalizeList(agentsRes);
                    const tickets = normalizeList(ticketsRes);

                    const pendingAgents = agents.filter(a => {
                        const st = (a.status ?? a.is_active ?? '').toString().toLowerCase();
                        return st === 'pending' || st === '0' || st === 'new';
                    }).length;

                    const pendingPayoutAmount = tickets.reduce((sum, t) => {
                        const status = (t.status || '').toString().toLowerCase();
                        const amt = parseFloat(t.amount ?? t.total_amount ?? t.price ?? 0) || 0;
                        return sum + ((status === 'pending' || status === 'unpaid') ? amt : 0);
                    }, 0);

                    const rows = [
                        { type: 'Agent Approval', details: `${pendingAgents} new agent application(s)`, priority: 'High', created: 'Now', actionText: 'Review' },
                        { type: 'Payout Processing', details: `₦ ${pendingPayoutAmount.toFixed(2)} in pending payouts`, priority: 'Medium', created: 'Now', actionText: 'Process' },
                        { type: 'System Backup', details: 'Weekly backup overdue', priority: 'Medium', created: '1 day ago', actionText: 'Run Backup' },
                        { type: 'Draw Management', details: 'Check next draw', priority: 'Low', created: 'Now', actionText: 'Prepare' }
                    ];

                    rows.forEach(r => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${r.type}</td>
                            <td>${r.details}</td>
                            <td><span class="status-badge status-pending">${r.priority}</span></td>
                            <td>${r.created}</td>
                            <td><button class="btn btn-sm btn-primary">${r.actionText}</button></td>
                        `;
                        tableBody.appendChild(tr);
                    });
                } catch (e) { console.warn('loadPendingActions failed', e); }
            }

            // Check simple availability of services and mark System Status badges
            async function checkServicesStatus() {
                try {
                    const checks = await Promise.allSettled([
                        axios.get('/loto/api/agent/list'),
                        axios.get('/loto/api/ticket/list'),
                        axios.get('/loto/api/draw/list')
                    ]);
                    // Map results to the 4 rows in System Status quick-stats
                    const statRows = Array.from(document.querySelectorAll('.admin-section')).find(s => s.querySelector('.section-title') && s.querySelector('.section-title').textContent.includes('System Status'));
                    if (!statRows) return;
                    const rows = statRows.querySelectorAll('.stat-row');
                    // Database -> agent list
                    const dbEl = rows[0]?.querySelector('span:last-child');
                    const payEl = rows[1]?.querySelector('span:last-child');
                    const apiEl = rows[2]?.querySelector('span:last-child');
                    const backupEl = rows[3]?.querySelector('span:last-child');

                    if (checks[0].status === 'fulfilled') { if (dbEl) { dbEl.className = 'status-badge status-active'; dbEl.textContent = 'Online'; } } else { if (dbEl) { dbEl.className = 'status-badge status-inactive'; dbEl.textContent = 'Offline'; } }
                    if (checks[1].status === 'fulfilled') { if (payEl) { payEl.className = 'status-badge status-active'; payEl.textContent = 'Online'; } } else { if (payEl) { payEl.className = 'status-badge status-pending'; payEl.textContent = 'Degraded'; } }
                    if (checks[2].status === 'fulfilled') { if (apiEl) { apiEl.className = 'status-badge status-active'; apiEl.textContent = 'Online'; } } else { if (apiEl) { apiEl.className = 'status-badge status-inactive'; apiEl.textContent = 'Offline'; } }
                    if (backupEl) { backupEl.className = 'status-badge status-pending'; backupEl.textContent = 'Pending'; }
                } catch (e) { console.warn('checkServicesStatus failed', e); }
            }

            // Wire quick actions (start draw / declare results) with minimal prompts
            document.querySelectorAll('.admin-action-btn').forEach(btn => {
                btn.addEventListener('click', function(ev) {
                    ev.preventDefault();
                    const action = this.textContent.trim();
                    if (action.includes('Start New Draw')) {
                        const name = prompt('Draw name/label:');
                        if (!name) return;
                        const date = prompt('Draw datetime (ISO) e.g. 2025-11-11T20:00:00:');
                        if (!date) return;
                        axios.post('/loto/api/draw/create', { name: name, draw_date: date })
                            .then(r => { alert('Draw started'); loadPendingActions(); })
                            .catch(e => { console.error(e); alert('Failed to start draw'); });
                        return;
                    }
                    if (action.includes('Declare Results')) {
                        const drawId = prompt('Draw id to declare results for:');
                        if (!drawId) return;
                        const numbers = prompt('Winning numbers (comma separated):');
                        if (!numbers) return;
                        const nums = numbers.split(/[ ,]+/).map(s=>s.trim()).filter(Boolean);
                        axios.post('/loto/api/winner/create', { draw_id: drawId, numbers: nums })
                            .then(r => { alert('Results declared'); loadLastResult(); updateAdminMetrics(); })
                            .catch(e => { console.error(e); alert('Failed to declare results'); });
                        return;
                    }
                    const href = this.getAttribute('href');
                    if (href) window.location = href;
                });
            });

            // initial loads
            loadAgents();
            loadLastResult();
            updateAdminMetrics();
            loadSystemNotice();
            loadPendingActions();
            checkServicesStatus();

            // polling / refresh intervals
            setInterval(updateAdminMetrics, 30000);
            setInterval(loadAgents, 20000);
            setInterval(loadLastResult, 10000);
            setInterval(loadPendingActions, 60000);
            setInterval(checkServicesStatus, 60000);
        });
    </script>
</body>
</html>
