<?php include_once('includes/head.php'); ?>
    <style>
        .metric-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-left: 4px solid;
            height: 100%;
        }
        .metric-card.active { border-left-color: #10b981; }
        .metric-card.suspended { border-left-color: #f59e0b; }
        .metric-card.canceled { border-left-color: #ef4444; }
        .metric-card.total { border-left-color: #3b82f6; }
        
        .metric-value {
            font-size: 24px;
            font-weight: 700;
            margin: 10px 0 5px 0;
        }
        .metric-label {
            color: #6b7280;
            font-size: 14px;
            font-weight: 500;
        }
        .metric-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            margin-bottom: 10px;
        }
        .metric-card.active .metric-icon { background: #10b981; color: white; }
        .metric-card.suspended .metric-icon { background: #f59e0b; color: white; }
        .metric-card.canceled .metric-icon { background: #ef4444; color: white; }
        .metric-card.total .metric-icon { background: #3b82f6; color: white; }
        
        .admin-action-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 15px;
            color: white;
            font-size: 14px;
            font-weight: 600;
            text-align: center;
            display: block;
            width: 100%;
            text-decoration: none;
            transition: transform 0.2s ease;
            margin-bottom: 10px;
        }
        .admin-action-btn:hover {
            transform: translateY(-2px);
            color: white;
            text-decoration: none;
        }
        .admin-action-btn.secondary {
            background: #6b7280;
        }
        .admin-action-btn.success {
            background: #10b981;
        }
        
        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        .status-active { background: #d1fae5; color: #065f46; }
        .status-suspended { background: #fef3c7; color: #92400e; }
        .status-canceled { background: #fee2e2; color: #991b1b; }
        .status-draft { background: #e5e7eb; color: #374151; }
        
        .system-alert {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
            border: 2px solid #f59e0b;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .alert-header {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        .alert-icon {
            color: #d97706;
            margin-right: 10px;
            font-size: 1.2rem;
        }
        
        .quick-stats {
            background: #f8fafc;
            border-radius: 10px;
            padding: 15px;
            margin: 10px 0;
        }
        .stat-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e2e8f0;
        }
        .stat-row:last-child {
            border-bottom: none;
        }
        
        .admin-section {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border: 1px solid #e3ebf6;
        }
        .section-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        .form-label {
            font-weight: 500;
            margin-bottom: 5px;
            display: block;
        }
        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #d1d5db;
            border-radius: 6px;
            font-size: 14px;
        }
        .form-select {
            width: 100%;
            padding: 10px;
            border: 1px solid #d1d5db;
            border-radius: 6px;
            font-size: 14px;
            background-color: white;
        }
        
        .game-card {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            border: 1px solid #e3ebf6;
            transition: all 0.3s ease;
        }
        .game-card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .game-name {
            font-weight: 600;
            font-size: 16px;
            margin-bottom: 5px;
        }
        .game-meta {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            color: #6b7280;
        }
        
        .action-btn {
            padding: 6px 10px;
            border: none;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s ease;
            white-space: nowrap;
        }
        .btn-edit {
            background: #3b82f6;
            color: white;
        }
        .btn-suspend {
            background: #f59e0b;
            color: white;
        }
        .btn-cancel {
            background: #ef4444;
            color: white;
        }
        .btn-activate {
            background: #10b981;
            color: white;
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }
        .modal-content {
            background: white;
            border-radius: 10px;
            padding: 30px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .modal-title {
            font-size: 1.25rem;
            font-weight: 600;
        }
        .close-modal {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: #6b7280;
        }
        
        .filter-section {
            background: #f8fafc;
            border-radius: 10px;
            padding: 15px;
            margin-top: 24px; /* added to provide space between stats and filters */
            margin-bottom: 20px;
        }
        .filter-group {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
            align-items: flex-end;
        }
        .filter-item {
            flex: 1;
            min-width: 200px;
        }
        .filter-item:last-child {
            min-width: 150px;
        }

        /* Multi-step form styles */
        .form-step { display: none; }
        .form-step.active { display: block; }
        .step-indicators { display:flex; gap:8px; margin-bottom:12px; }
        .step-indicators .step { padding:6px 10px; border-radius:6px; background:#f1f5f9; font-size:13px; }
        .step-indicators .step.active { background:#3b82f6; color:white; }
        
        .tab-container {
            margin-bottom: 20px;
        }
        .tabs {
            display: flex;
            border-bottom: 1px solid #e2e8f0;
        }
        .tab {
            padding: 10px 20px;
            cursor: pointer;
            border-bottom: 2px solid transparent;
            font-weight: 500;
        }
        .tab.active {
            border-bottom-color: #3b82f6;
            color: #3b82f6;
        }
        
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }
        .page-item {
            padding: 8px 12px;
            border: 1px solid #d1d5db;
            border-radius: 6px;
            cursor: pointer;
        }
        .page-item.active {
            background: #3b82f6;
            color: white;
            border-color: #3b82f6;
        }
    </style>

<style>
        /* Loading overlay */
        #pageLoader {
            display: none;
            position: fixed;
            top: 0; left: 0; right:0; bottom:0;
            background: rgba(0,0,0,0.35);
            z-index: 2000;
            align-items: center;
            justify-content: center;
        }
        #pageLoader .loaderBox {
            background: white; padding: 18px 24px; border-radius: 8px; display:flex; gap:12px; align-items:center;
            box-shadow: 0 6px 20px rgba(0,0,0,0.2);
        }
        .spinner {
            width: 28px; height: 28px; border: 4px solid #eee; border-top-color: #3b82f6; border-radius:50%; animation: spin 1s linear infinite;
        }
        @keyframes spin { to { transform: rotate(360deg); } }
    </style>

<body class="nk-body bg-light has-sidebar">
    <!-- Top Navigation -->
   <?php include_once('includes/head.php'); ?>

    <!-- Sidebar -->
   <?php include_once('includes/sidebar.php'); ?>

    <!-- Main Content -->
    <div class="nk-wrap">
        <div class="nk-content">
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="nk-block-head">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Game Management</h3>
                            <div class="nk-block-des text-soft">
                                <p>Create and manage all lottery games in the system</p>
                            </div>
                        </div>
                        <div class="nk-block-head-content">
                            <button class="admin-action-btn" onclick="openCreateGameModal()">
                                <i class="fas fa-plus-circle me-2"></i>Create New Game
                            </button>
                        </div>
                    </div>
                </div>

                <!-- System Alert -->
                <!-- <div class="system-alert">
                    <div class="alert-header">
                        <i class="fas fa-exclamation-triangle alert-icon"></i>
                        <strong>System Notice</strong>
                    </div>
                    <p class="mb-0">5 games are currently suspended. 2 new games created today.</p>
                </div> -->

                <!-- Game Statistics -->
                <div class="nk-block">
                    <div class="row g-gs">
                        <div class="col-sm-6 col-lg-3">
                            <div class="metric-card total">
                                <div class="metric-icon">
                                    <i class="fas fa-dice"></i>
                                </div>
                                <div class="metric-value" id="metricTotalGames">0</div>
                                <div class="metric-label">Total Games</div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="metric-card active">
                                <div class="metric-icon">
                                    <i class="fas fa-play-circle"></i>
                                </div>
                                <div class="metric-value" id="metricActiveGames">0</div>
                                <div class="metric-label">Active Games</div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="metric-card suspended">
                                <div class="metric-icon">
                                    <i class="fas fa-pause-circle"></i>
                                </div>
                                <div class="metric-value" id="metricSuspendedGames">0</div>
                                <div class="metric-label">Suspended Games</div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="metric-card canceled">
                                <div class="metric-icon">
                                    <i class="fas fa-times-circle"></i>
                                </div>
                                <div class="metric-value" id="metricCanceledGames">0</div>
                                <div class="metric-label">Canceled Games</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Filters Section -->
                <div class="filter-section">
                    <h6 class="section-title">
                        <i class="fas fa-filter"></i>
                        Filter Games
                    </h6>
                    <div class="filter-group">
                        <div class="filter-item">
                            <label class="form-label">Status</label>
                            <select class="form-select" id="statusFilter">
                                <option value="">All Status</option>
                                <option value="active">Active</option>
                                <option value="suspended">Suspended</option>
                                <option value="canceled">Canceled</option>
                                <option value="draft">Draft</option>
                            </select>
                        </div>
                        <div class="filter-item">
                            <label class="form-label">Date Range</label>
                            <input type="date" class="form-control" id="dateFilter">
                        </div>
                        <div class="filter-item">
                            <label class="form-label">Search</label>
                            <input type="text" class="form-control" id="searchFilter" placeholder="Search games...">
                        </div>
                        <div class="filter-item">
                            <button class="admin-action-btn secondary" onclick="applyFilters()">
                                <i class="fas fa-search me-2"></i>Apply Filters
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Tabs -->
                <div class="tab-container">
                    <div class="tabs">
                        <div class="tab active" onclick="switchTab('all', this)">All Games</div>
                            <div class="tab" onclick="switchTab('active', this)">Active</div>
                            <div class="tab" onclick="switchTab('suspended', this)">Suspended</div>
                            <div class="tab" onclick="switchTab('canceled', this)">Canceled</div>
                    </div>
                </div>

                <!-- Games Table -->
                <div class="admin-section">
                    <div class="card-title-group">
                        <div class="card-title">
                            <h6 class="title">All Games</h6>
                        </div>
                        <div class="card-tools">
                            <span class="text-muted">Showing 1-22 of 22 games</span>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Game ID</th>
                                    <th>Game Name</th>
                                    <th>Status</th>
                                    <th>Created Date</th>
                                    <th>Last Updated</th>
                                    <th>Bets Today</th>
                                    <th>Revenue Today</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="gamesTableBody">
                                <!-- Games will be populated by JavaScript -->
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="pagination">
                        <div class="page-item active">1</div>
                        <div class="page-item">2</div>
                        <div class="page-item">3</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Global loading overlay -->
    <div id="pageLoader"><div class="loaderBox"><div class="spinner"></div><div id="loaderText">Working...</div></div></div>

    <!-- Create Game Modal -->
    <div id="createGameModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New Game</h5>
                <button class="close-modal" onclick="closeCreateGameModal()">&times;</button>
            </div>
            <form id="createGameForm">
                <div class="step-indicators">
                    <div class="step active" data-step="1">Basic</div>
                    <div class="step" data-step="2">Pricing</div>
                    <div class="step" data-step="3">Review</div>
                </div>

                <!-- Step 1: Basic Info -->
                <div class="form-step active" data-step="1">
                    <div class="form-group">
                        <label class="form-label">Game Name</label>
                        <select class="form-select" id="gameName">
                            <option value="">Select Game Name</option>
                            <option value="NATIONAL">NATIONAL</option>
                            <option value="MONDAY SPECIAL">MONDAY SPECIAL</option>
                            <option value="PEOPLE">PEOPLE</option>
                            <option value="GOLDEN BLUE">GOLDEN BLUE</option>
                            <option value="JACKPOT">JACKPOT</option>
                            <option value="LUCKB">LUCKB</option>
                            <option value="WAZOBIA">WAZOBIA</option>
                            <option value="GATEWAY">GATEWAY</option>
                            <option value="BLUESTAR">BLUESTAR</option>
                            <option value="BONANZA">BONANZA</option>
                            <option value="GHANA BLUE">GHANA BLUE</option>
                            <option value="MIDWEEK">MIDWEEK</option>
                            <option value="SUPER">SUPER</option>
                            <option value="WINNERS">WINNERS</option>
                            <option value="FORTUNE">FORTUNE</option>
                            <option value="SUNSHINE">SUNSHINE</option>
                            <option value="OMEGA">OMEGA</option>
                            <option value="PRIME FRIDAY">PRIME FRIDAY</option>
                            <option value="METRO">METRO</option>
                            <option value="MILLIONAIRE">MILLIONAIRE</option>
                            <option value="SUPREME">SUPREME</option>
                            <option value="BLUE CHANCE">BLUE CHANCE</option>
                            <option value="SUCCESS">SUCCESS</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Custom Game Name (if not in list)</label>
                        <input type="text" class="form-control" id="customGameName" placeholder="Enter custom game name">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Game Type</label>
                        <select class="form-select" id="gameType">
                            <option value="">Select Game Type</option>
                            <option value="5/90">5/90</option>
                            <option value="6/90">6/90</option>
                            <option value="4/40">4/40</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    <div style="display:flex; gap:10px; justify-content:flex-end; margin-top:12px;">
                        <button type="button" class="admin-action-btn secondary" onclick="goToStep(2)">Next</button>
                    </div>
                </div>

                <!-- Step 2: Pricing & Rules -->
                <div class="form-step" data-step="2">
                    <div class="form-group">
                        <label class="form-label">Ticket Price (NGN)</label>
                        <input type="number" min="0" step="0.01" class="form-control" id="ticketPrice" placeholder="e.g. 100" value="100">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Numbers to Pick</label>
                        <input type="number" min="1" class="form-control" id="numbersToPick" placeholder="e.g. 5">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Maximum Number</label>
                        <input type="number" min="1" class="form-control" id="maxNumber" placeholder="e.g. 90" value="90">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Has Bonus Number?</label>
                        <select class="form-select" id="hasBonus">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Has Jackpot Number?</label>
                        <select class="form-select" id="hasJackpot">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                    <div style="display:flex; gap:10px; justify-content:space-between; margin-top:12px;">
                        <button type="button" class="admin-action-btn secondary" onclick="goToStep(1)">Back</button>
                        <button type="button" class="admin-action-btn" onclick="goToStep(3)">Next</button>
                    </div>
                </div>

                <!-- Step 3: Review & Submit -->
                <div class="form-step" data-step="3">
                    <div class="form-group">
                        <label class="form-label">Initial Status</label>
                        <select class="form-select" id="gameStatus">
                            <option value="active">Active</option>
                            <option value="suspended">Suspended</option>
                            <option value="draft">Draft</option>
                        </select>
                    </div>
                
                    <div style="display:flex; gap:10px; justify-content:space-between; margin-top:12px;">
                        <button type="button" class="admin-action-btn secondary" onclick="goToStep(2)">Back</button>
                        <button type="submit" class="admin-action-btn success">Create Game</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Edit Game Modal (multi-step copy) -->
    <div id="editGameModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Game</h5>
                <button class="close-modal" onclick="closeEditGameModal()">&times;</button>
            </div>
            <form id="editGameForm">
                <input type="hidden" id="editGameId">
                <div class="step-indicators">
                    <div class="step active" data-step="1">Basic</div>
                    <div class="step" data-step="2">Pricing</div>
                    <div class="step" data-step="3">Review</div>
                </div>

                <div class="form-step active" data-step="1">
                    <div class="form-group">
                        <label class="form-label">Game Name</label>
                        <input class="form-control" id="editGameName">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Game Type</label>
                        <select class="form-select" id="editGameType">
                            <option value="">Select Game Type</option>
                            <option value="5/90">5/90</option>
                            <option value="6/90">6/90</option>
                            <option value="4/40">4/40</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    <div style="display:flex; gap:10px; justify-content:flex-end; margin-top:12px;">
                        <button type="button" class="admin-action-btn secondary" onclick="goToStepEdit(2)">Next</button>
                    </div>
                </div>

                <div class="form-step" data-step="2">
                    <div class="form-group">
                        <label class="form-label">Ticket Price (NGN)</label>
                        <input type="number" min="0" step="0.01" class="form-control" id="editTicketPrice">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Numbers to Pick</label>
                        <input type="number" min="1" class="form-control" id="editNumbersToPick">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Maximum Number</label>
                        <input type="number" min="1" class="form-control" id="editMaxNumber">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Has Bonus Number?</label>
                        <select class="form-select" id="editHasBonus">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Has Jackpot Number?</label>
                        <select class="form-select" id="editHasJackpot">
                            <option value="0">No</option>
                            <option value="1">Yes</option>
                        </select>
                    </div>
                    <div style="display:flex; gap:10px; justify-content:space-between; margin-top:12px;">
                        <button type="button" class="admin-action-btn secondary" onclick="goToStepEdit(1)">Back</button>
                        <button type="button" class="admin-action-btn" onclick="goToStepEdit(3)">Next</button>
                    </div>
                </div>

                <div class="form-step" data-step="3">
                    <div class="form-group">
                        <label class="form-label">Initial Status</label>
                        <select class="form-select" id="editGameStatus">
                            <option value="active">Active</option>
                            <option value="suspended">Suspended</option>
                            <option value="draft">Draft</option>
                        </select>
                    </div>
                    <div style="display:flex; gap:10px; justify-content:space-between; margin-top:12px;">
                        <button type="button" class="admin-action-btn secondary" onclick="goToStepEdit(2)">Back</button>
                        <button type="submit" class="admin-action-btn success">Save Changes</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="/loto/public/assets/js/bundle9b70.js?ver=3.3.0"></script>
    <script src="/loto/public/assets/js/scripts9b70.js?ver=3.3.0"></script>
    <!-- Axios for AJAX calls -->
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <script>
    // Games array will be populated from the API at runtime
    let games = [];

    // Configure axios to send cookies (sessions)
    axios.defaults.withCredentials = true;

    // Pagination & filter state
    let currentTab = 'all';
    let currentPage = 1;
    const pageSize = 10; // items per page
    let filteredGamesCache = [];

    // Initialize the page
    document.addEventListener('DOMContentLoaded', function() {
        loadGamesFromAPI();
    });

    // Load games from backend API
    function loadGamesFromAPI() {
        setBusy(true, 'Loading games...');
        axios.get('/loto/api/game/list')
            .then(response => {
                console.log(response);
                // Log raw response for debugging response shape
                console.log('GET /loto/api/game/list response:', response && response.data ? response.data : response);

                // const list = (response.data && (response.data.state || response.data.message)) ? (response.data.state || response.data.message) : null;
                const list = response.data.message || response.data.state || [];
                console.log('Extracted game list:', list);
                if (Array.isArray(list)) {
                    // Map server game objects into UI-friendly shape
                    games = list.map(g => ({
                        id: g.id,
                        name: g.name,
                        code: g.code,
                        // normalize status: backend may use is_active numeric flag or a string
                        status: (g.is_active == 1 || g.is_active === '1' || g.status === 'active') ? 'active' : (g.is_active == 0 || g.status === 'suspended' ? 'suspended' : (g.status || 'draft')),
                        created: g.created_at || g.created || null,
                        updated: g.updated_at || g.updated || null,
                        bets: g.total_bets ?? 0,
                        revenue: (g.total_sales !== undefined && g.total_sales !== null) ? ('₦ ' + Number(g.total_sales).toFixed(2)) : '₦ 0.00',
                        // keep raw fields for edit modal
                        ticket_price: g.ticket_price ?? g.ticketPrice ?? null,
                        numbers_to_pick: g.numbers_to_pick ?? g.numbersToPick ?? null,
                        max_number: g.max_number ?? g.maxNumber ?? null,
                        has_bonus: g.has_bonus ?? g.hasBonus ?? 0,
                        has_jackpot_num: g.has_jackpot_num ?? g.hasJackpot ?? 0
                    }));

                    // initialize filters/pagination
                    currentPage = 1;
                    currentTab = 'all';
                    filteredGamesCache = games.slice();
                    renderGamesPage();
                    updateMetrics();
                } else {
                    console.warn('Game list: unexpected response', response.data);
                    filteredGamesCache = [];
                    renderGamesPage();
                    updateMetrics();
                }
            })
            .catch(err => {
                console.error('Failed to load games from API', err);
                // Render empty state so UI reflects live status
                filteredGamesCache = [];
                renderGamesPage();
                updateMetrics();
            })
            .finally(() => setBusy(false));
    }

    // Render the current page of games based on filteredGamesCache, currentPage, pageSize
    function renderGamesPage() {
        const totalItems = filteredGamesCache.length;
        const start = (currentPage - 1) * pageSize;
        const end = start + pageSize;
        const pageItems = filteredGamesCache.slice(start, end);
        renderGamesTable(pageItems);
        renderPagination(totalItems);
    }

    function renderPagination(totalItems) {
        const container = document.querySelector('.pagination');
        if (!container) return;
        container.innerHTML = '';
        const totalPages = Math.max(1, Math.ceil(totalItems / pageSize));

        // Previous
        const prev = document.createElement('div');
        prev.className = 'page-item';
        prev.textContent = '<';
        prev.onclick = function() { if (currentPage > 1) { currentPage--; renderGamesPage(); } };
        container.appendChild(prev);

        for (let p = 1; p <= totalPages; p++) {
            const item = document.createElement('div');
            item.className = 'page-item' + (p === currentPage ? ' active' : '');
            item.textContent = p;
            item.onclick = (function(page) { return function() { currentPage = page; renderGamesPage(); }; })(p);
            container.appendChild(item);
        }

        // Next
        const next = document.createElement('div');
        next.className = 'page-item';
        next.textContent = '>';
        next.onclick = function() { if (currentPage < totalPages) { currentPage++; renderGamesPage(); } };
        container.appendChild(next);
    }

    // Update metric cards (total, active, suspended, canceled) based on current games array
    function updateMetrics() {
        const total = games.length;
        const active = games.filter(g => g.status === 'active').length;
        const suspended = games.filter(g => g.status === 'suspended').length;
        const canceled = games.filter(g => g.status === 'canceled').length;

        const elTotal = document.getElementById('metricTotalGames');
        const elActive = document.getElementById('metricActiveGames');
        const elSuspended = document.getElementById('metricSuspendedGames');
        const elCanceled = document.getElementById('metricCanceledGames');

        if (elTotal) elTotal.textContent = total;
        if (elActive) elActive.textContent = active;
        if (elSuspended) elSuspended.textContent = suspended;
        if (elCanceled) elCanceled.textContent = canceled;
    }

        // Render games table
        function renderGamesTable(gamesData) {
            console.log('Rendering games table with data:', gamesData);
            const tableBody = document.getElementById('gamesTableBody');
            tableBody.innerHTML = '';
            // If no games, show a friendly empty state
            if (!gamesData || gamesData.length === 0) {
                const row = document.createElement('tr');
                row.innerHTML = `<td colspan="8" style="text-align:center; padding:20px; color:#6b7280;">No games found.</td>`;
                tableBody.appendChild(row);
                return;
            }

            gamesData.forEach(game => {
                const statusBadge = getStatusBadge(game.status);
                const row = document.createElement('tr');
                
                row.innerHTML = `
                    <td><strong>${game.id}</strong></td>
                    <td>${game.name}</td>
                    <td>${statusBadge}</td>
                    <td>${formatDate(game.created)}</td>
                    <td>${formatDate(game.updated)}</td>
                    <td>${game.bets}</td>
                    <td>${game.revenue}</td>
                    <td>
                        ${game.status !== 'active' ? `<button class="action-btn btn-activate" onclick="changeGameStatus('${game.id}', 'active')">Activate</button>` : ''}
                        ${game.status !== 'suspended' ? `<button class="action-btn btn-suspend" onclick="changeGameStatus('${game.id}', 'suspended')">Suspend</button>` : ''}
                        ${game.status !== 'canceled' ? `<button class="action-btn btn-cancel" data-action="delete" data-id="${game.id}">Cancel</button>` : ''}
                        <button class="action-btn btn-edit" data-action="edit" data-id="${game.id}">Edit</button>
                    </td>
                `;
                
                tableBody.appendChild(row);
            });

            // attach delegated handlers for newly created buttons
            tableBody.querySelectorAll('button[data-action]').forEach(btn => {
                const action = btn.getAttribute('data-action');
                const id = btn.getAttribute('data-id');
                if (action === 'delete') btn.onclick = () => deleteGame(id);
                if (action === 'edit') btn.onclick = () => editGame(id);
            });
        }

        // Get status badge HTML
        function getStatusBadge(status) {
            const statusMap = {
                'active': 'status-active',
                'suspended': 'status-suspended', 
                'canceled': 'status-canceled',
                'draft': 'status-draft'
            };
            
            const statusText = {
                'active': 'Active',
                'suspended': 'Suspended',
                'canceled': 'Canceled',
                'draft': 'Draft'
            };
            
            return `<span class="status-badge ${statusMap[status]}">${statusText[status]}</span>`;
        }

        // Format date for display
        function formatDate(dateString) {
            const date = new Date(dateString);
            return date.toLocaleDateString() + ' ' + date.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
        }

        // Change game status (calls API)
        function changeGameStatus(gameId, newStatus) {
            if (!confirm(`Are you sure you want to ${newStatus} this game?`)) return;

            // Map UI status to is_active value expected by the backend
            const isActive = (newStatus === 'active') ? 1 : 0;

            axios.post('/loto/api/game/update', {
                id: gameId,
                payload: { is_active: isActive }
            })
            .then(resp => {
                if (resp.data && resp.data.success) {
                    // Update UI locally
                    const gameIndex = games.findIndex(game => game.id == gameId);
                    if (gameIndex !== -1) {
                        games[gameIndex].status = newStatus;
                        games[gameIndex].updated = new Date().toISOString().replace('T', ' ').substring(0, 19);
                        applyFilters();
                    } else {
                        // reload list if item not found locally
                        loadGamesFromAPI();
                    }
                    alert(`Game ${gameId} status changed to ${newStatus}`);
                } else {
                    alert('Failed to change game status: ' + (resp.data.message || 'Unknown error'));
                }
            })
            .catch(err => {
                console.error('Status change error', err);
                alert('Error changing game status');
            });
        }

        // Edit game (placeholder function)
        // Open edit modal for an existing game
        function editGame(gameId) {
            const g = games.find(x => x.id == gameId);
            if (!g) { alert('Game not found'); return; }
            // Populate edit modal fields
            document.getElementById('editGameId').value = g.id;
            document.getElementById('editGameName').value = g.name;
            // try to set code/game type
            document.getElementById('editGameType').value = g.code || '';
            // try parsing numbers_to_pick and max_number if present in game object
            document.getElementById('editTicketPrice').value = g.ticket_price ?? '';
            document.getElementById('editNumbersToPick').value = g.numbers_to_pick ?? '';
            document.getElementById('editMaxNumber').value = g.max_number ?? '';
            document.getElementById('editHasBonus').value = g.has_bonus ?? '0';
            document.getElementById('editHasJackpot').value = g.has_jackpot_num ?? '0';
            document.getElementById('editGameStatus').value = (g.status === 'active') ? 'active' : (g.status === 'suspended' ? 'suspended' : 'draft');
            // show modal
            document.getElementById('editGameModal').style.display = 'flex';
            // reset to first step
            goToStepEdit(1);
        }

        // Switch tabs
        function switchTab(tab) {
            // Update active tab element (el is passed from onclick)
            const el = arguments[1];
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            if (el && el.classList) el.classList.add('active');

            // Set current tab and apply filters
            currentTab = tab;
            applyFilters();
        }

        // Apply filters
        function applyFilters() {
            const statusFilter = document.getElementById('statusFilter').value;
            const searchFilter = document.getElementById('searchFilter').value.toLowerCase();
            
            // Start with full list
            let filteredGames = games.slice();

            // Apply tab filter (from tabs)
            if (currentTab && currentTab !== 'all') {
                filteredGames = filteredGames.filter(game => game.status === currentTab);
            }

            // Apply status filter (dropdown)
            if (statusFilter) {
                filteredGames = filteredGames.filter(game => game.status === statusFilter);
            }

            // Apply search filter
            if (searchFilter) {
                filteredGames = filteredGames.filter(game => 
                    (game.name && game.name.toLowerCase().includes(searchFilter)) || 
                    (game.id && game.id.toString().toLowerCase().includes(searchFilter))
                );
            }

            // Update cache and reset to first page
            filteredGamesCache = filteredGames;
            currentPage = 1;
            renderGamesPage();
        }

        // Modal functions
        function openCreateGameModal() {
            document.getElementById('createGameModal').style.display = 'flex';
        }

        function closeCreateGameModal() {
            document.getElementById('createGameModal').style.display = 'none';
            document.getElementById('createGameForm').reset();
        }

        // Step navigation for create form
        function goToStep(step) {
            const steps = document.querySelectorAll('.form-step');
            steps.forEach(s => s.classList.remove('active'));
            const target = document.querySelector('.form-step[data-step="' + step + '"]');
            if (target) target.classList.add('active');

            // update indicators
            document.querySelectorAll('.step-indicators .step').forEach(ind => {
                ind.classList.toggle('active', ind.getAttribute('data-step') == step);
            });
        }

        // Handle form submission (create game via API)
        document.getElementById('createGameForm').addEventListener('submit', function(e) {
            e.preventDefault();

            // Collect fields from all steps
            const gameName = document.getElementById('gameName').value;
            const customName = document.getElementById('customGameName').value;
            const gameType = document.getElementById('gameType').value;
            const ticketPrice = parseFloat(document.getElementById('ticketPrice').value) || 0;
            const numbersToPickField = document.getElementById('numbersToPick').value;
            const numbersToPick = numbersToPickField ? parseInt(numbersToPickField, 10) : null;
            const maxNumberField = document.getElementById('maxNumber').value;
            const maxNumber = maxNumberField ? parseInt(maxNumberField, 10) : null;
            const hasBonus = parseInt(document.getElementById('hasBonus').value, 10) === 1 ? 1 : 0;
            const hasJackpot = parseInt(document.getElementById('hasJackpot').value, 10) === 1 ? 1 : 0;
            const gameStatus = document.getElementById('gameStatus').value;

            const finalGameName = customName || gameName;

            // Basic validation
            if (!finalGameName) {
                alert('Please select or enter a game name');
                goToStep(1);
                return;
            }

            if (!gameType) {
                alert('Please select a game type');
                goToStep(1);
                return;
            }

            if (!numbersToPick || !maxNumber) {
                alert('Please provide numbers to pick and max number');
                goToStep(2);
                return;
            }

            const payload = {
                name: finalGameName,
                code: gameType,
                numbers_to_pick: numbersToPick,
                max_number: maxNumber,
                has_bonus: hasBonus,
                has_jackpot_num: hasJackpot,
                ticket_price: ticketPrice || 0,
                is_active: (gameStatus === 'active') ? 1 : 0
            };

            setBusy(true, 'Creating game...');
            axios.post('/loto/api/game/create', payload)
                .then(resp => {
                    if (resp.data && (resp.data.success || resp.data.state)) {
                        closeCreateGameModal();
                        // refresh list from API to get canonical data
                        loadGamesFromAPI();
                        alert('Game "' + finalGameName + '" created successfully!');
                    } else {
                        alert('Failed to create game: ' + (resp.data.message || resp.data.msg || 'Unknown error'));
                    }
                })
                .catch(err => {
                    console.error('Create game error', err);
                    alert('Error creating game');
                })
        .finally(() => setBusy(false));
    });

        // Edit modal helpers
        function closeEditGameModal() {
            document.getElementById('editGameModal').style.display = 'none';
            document.getElementById('editGameForm').reset();
        }

        function goToStepEdit(step) {
            const steps = document.querySelectorAll('#editGameModal .form-step');
            steps.forEach(s => s.classList.remove('active'));
            const target = document.querySelector('#editGameModal .form-step[data-step="' + step + '"]');
            if (target) target.classList.add('active');
            document.querySelectorAll('#editGameModal .step-indicators .step').forEach(ind => ind.classList.toggle('active', ind.getAttribute('data-step') == step));
        }

        // Handle edit form submission
        document.getElementById('editGameForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const id = document.getElementById('editGameId').value;
            const name = document.getElementById('editGameName').value;
            const code = document.getElementById('editGameType').value;
            const ticket_price = parseFloat(document.getElementById('editTicketPrice').value) || 0;
            const numbers_to_pick = parseInt(document.getElementById('editNumbersToPick').value) || 0;
            const max_number = parseInt(document.getElementById('editMaxNumber').value) || 0;
            const has_bonus = parseInt(document.getElementById('editHasBonus').value) ? 1 : 0;
            const has_jackpot_num = parseInt(document.getElementById('editHasJackpot').value) ? 1 : 0;
            const is_active = (document.getElementById('editGameStatus').value === 'active') ? 1 : 0;

            const payload = {
                name, code, ticket_price, numbers_to_pick, max_number, has_bonus, has_jackpot_num, is_active
            };

            setBusy(true, 'Saving changes...');
            axios.post('/loto/api/game/update', { id: id, payload: payload })
                .then(resp => {
                    if (resp.data && (resp.data.success || resp.data.state)) {
                        closeEditGameModal();
                        loadGamesFromAPI();
                        alert('Game updated');
                    } else {
                        alert('Failed to update game: ' + (resp.data.message || resp.data.msg || 'Unknown error'));
                    }
                })
                .catch(err => { console.error('Update game error', err); alert('Error updating game'); })
                .finally(() => setBusy(false));
        });

        // Close modal when clicking outside
        window.addEventListener('click', function(e) {
            const modal = document.getElementById('createGameModal');
            if (e.target === modal) {
                closeCreateGameModal();
            }
        });

        // Delete game (called from Cancel button)
        function deleteGame(gameId) {
            // console.log('Deleting game', gameId);
            if (!confirm('Are you sure you want to delete this game? This action cannot be undone.')) return;
            setBusy(true, 'Deleting...');
            // axios.delete's second parameter is the config object; include the id as data so server can read JSON body
            axios.delete('/loto/api/game/delete', { data: { id: gameId } })
                .then(resp => {
                    if (resp.data && (resp.data.success || resp.data.state)) {
                        // reload list
                        loadGamesFromAPI();
                        alert('Game deleted');
                    } else {
                        alert('Failed to delete game: ' + (resp.data.message || resp.data.msg || 'Unknown error'));
                    }
                })
                .catch(err => {
                    console.error('Delete game error', err);
                    alert('Error deleting game');
                })
                .finally(() => setBusy(false));
        }

        // Busy helper - show overlay and disable inputs while in-flight
        function setBusy(state, message) {
            const loader = document.getElementById('pageLoader');
            const loaderText = document.getElementById('loaderText');
            if (loaderText && message) loaderText.textContent = message;
            if (state) {
                if (loader) loader.style.display = 'flex';
                // disable interactive elements
                document.querySelectorAll('button, input, select, textarea').forEach(el => { el.dataset._disabled = String(el.disabled); el.disabled = true; });
            } else {
                if (loader) loader.style.display = 'none';
                // restore prior disabled state
                document.querySelectorAll('button, input, select, textarea').forEach(el => { el.disabled = (el.dataset._disabled === 'true'); delete el.dataset._disabled; });
            }
        }
    </script>
</body>
</html>