<?php

namespace Middleware;

use UserSubscription\UserSubscription;

require_once('./bootstrap.php');
// require_once('./models/Course/Course.php');
// require_once('./models/QA/QuestionAnswerSession.php');
// require_once('./models/Subscription/SubscriptionPlan.php');
// require_once('./models/Subscription/UserSubscription.php');

// use Course\Course;
// use SubscriptionPlan\SubscriptionPlan;
// use QuestionAnswerSession\QuestionAnswerSession;

use Database\Database;
use _Helpers\SQLDB;
use _Helpers\ToolHelper;
use _Helpers\SessionService;
use _Helpers\ServerHandler;
use _Helpers\QueryBuilder;
// JWT removed: middleware now uses session-based auth only
class Middleware
{
    protected static SQLDB $sqlDB;
    protected static ToolHelper $toolHelper;
    protected static SessionService $sessionService;
    protected static QueryBuilder $qb;
    protected static bool $initialized = false;

    // Initialize dependencies once
    public static function init()
    {
        if (!self::$initialized) {
            global $dsn, $username, $password; // Use global variables from db_credentials.php

            $pdo = Database::getInstance()->getConnection();
            self::$sqlDB = new SQLDB($pdo);
            self::$toolHelper = new ToolHelper();
            self::$sessionService = new SessionService();
            self::$qb = new QueryBuilder($pdo);
            // no JWT initialization — sessions only
            self::$initialized = true;
        }
    }
    //check if users exists
    public static function userExists()
    {
        self::init();
        $userId = $_GET['user_id'] ?? null;
        // Implement logic to check if the user exists in the database
        $user = self::$qb->table('users')
            ->where('user_id', '=', $userId)
            ->first();
        // do nothing if user exists,else redirect to 404
        if (!$user) {
            header("HTTP/1.0 404 Not Found");
            //redirect instead of include
            header('Location: 404');
            exit();
        }
        return true;
    }
    
    public static function requireAdminAuth()
    {
        self::init();
        // Session-based auth only
        if (session_status() == PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'admin') {
            return [
                'user_id' => $_SESSION['user_id'],
                'role' => $_SESSION['role']
            ];
        }

        // Not authenticated — redirect to admin login
        header('Location: https://blueextralotto.com/blueextra/admin/login');
        exit();
    }
    public static function restrictLoginIfAuthenticated() {
        self::init();
        // If session already exists, redirect away from login
        if (session_status() == PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'admin') {
            header('Location: https://blueextralotto.com/blueextra/admin/');
            exit();
        }
        return;
    }
    public static function requireUserAuth()
    {
        self::init();
        // Session-based auth only
        if (session_status() == PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'user') {
            return [
                'user_id' => $_SESSION['user_id'],
                'role' => $_SESSION['role']
            ];
        }

        // Not authenticated — redirect to user login
        header('Location: https://blueextralotto.com/blueextra/user/login');
        exit();
    }
    public static function restrictLoginIfAuthenticatedUser() {
        self::init();
        // If session already exists, redirect away from login
        if (session_status() == PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'user') {
            header('Location: http://localhost/niels/user/');
            exit();
        }
        return;
    }

    public static function requireAgentAuth()
    {
        self::init();
        // Session-based auth only
        if (session_status() == PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'agent') {
            return [
                'user_id' => $_SESSION['user_id'],
                'role' => $_SESSION['role']
            ];
        }

        // Not authenticated — redirect to agent login
        header('Location: http://localhost/niels/agent/login');
        exit();
    }
}