<?php
// Contact form processing: validate and send email to info@kaleelconsult.com
// Load composer autoload and project helpers (ToolHelper with SMTP)
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../../_Helpers.php';

$contact_errors = [];
$contact_success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $subject = trim($_POST['subject'] ?? 'New contact message');
    $message = trim($_POST['message'] ?? '');

    if ($name === '') $contact_errors[] = 'Please enter your name.';
    if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) $contact_errors[] = 'Please enter a valid email address.';
    if ($message === '') $contact_errors[] = 'Please enter a message.';

    if (empty($contact_errors)) {
        $to = 'info@kaleelconsult.com';
        $body = "Name: {$name}\nEmail: {$email}\nSubject: {$subject}\n\nMessage:\n{$message}";
        // Use centralized ToolHelper SMTP sender to avoid local mail() dependency
        try {
            $mailer = new \_Helpers\ToolHelper();
            $result = $mailer->sendMail($to, $subject ?: 'Contact Form Message', nl2br(htmlspecialchars($body)), 'no-reply@kaleelconsult.com', 'Kaleel Consult');
            if (!empty($result['success'])) {
                $contact_success = 'Message sent successfully. We will respond shortly.';
            } else {
                $contact_errors[] = $result['message'] ?? 'Unable to send message right now. Please try again later.';
            }
        } catch (\Throwable $e) {
            $contact_errors[] = 'Unable to send message right now. Please try again later.';
        }
    }

    // If this was an AJAX request, return JSON response and exit
    $isAjax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
        strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
    if ($isAjax) {
        header('Content-Type: application/json');
        if (!empty($contact_errors)) {
            echo json_encode(['status' => 'error', 'errors' => $contact_errors]);
        } else {
            echo json_encode(['status' => 'success', 'message' => $contact_success]);
        }
        exit;
    }
}

include_once('includes/head.php'); ?>

<body class="body-color">

    <!-- preloader -->
    <div id="preloader">
        <div class="loader"></div>
    </div>

    <!-- Back To Top Start -->
    <button id="back-top" class="back-to-top">
        <i class="fa-solid fa-arrow-up"></i>
    </button>

    <!--<< Mouse Cursor Start >>-->
    <div class="mouse-cursor cursor-outer"></div>
    <div class="mouse-cursor cursor-inner"></div>

    <!-- ht-header-area start -->
    <?php include_once('includes/header.php'); ?>
    <!-- ht-header-area end -->

    <!-- offcanvas for navigation -->
    <?php include_once('includes/sidebar.php'); ?>

    <!-- offcanvas overlay -->
    <div class="ht-offcanvas-overlay"></div>

    <!-- ht breadcrumb area start -->
    <section class="ht-breadcrumb-area">
        <div class="container">
            <div class="ht-breadcrumb-heading">
                <h2 class="ht-breadcrumb-title">Contact Us</h2>
                <ul class="ht-breadcrumb-list">
                    <li><a href="index.html">Home</a></li>
                    <li><i class="fa-solid fa-chevron-right"></i></li>
                    <li class="active">Contact Us</li>
                </ul>
            </div>
        </div>
    </section>
    <!-- ht breadcrumb area start -->

    <!-- ht contact info area -->
    <section class="ht-contact-info-area section-padding">
        <div class="container">
            <div class="contact-info-wrapper">
                <div class="row gy-5">
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="contact-info-item">
                            <div class="icon">
                                <i class="fa-solid fa-phone" aria-hidden="true"></i>
                            </div>
                            <div class="content">
                                <span>Phone number</span>
                                <h4>+44 204 577 0077</h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".6s">
                        <div class="contact-info-item">
                            <div class="icon">
                                <i class="fa-solid fa-envelope" aria-hidden="true"></i>
                            </div>
                            <div class="content">
                                <span>Email address</span>
                                <a href="mailto:info@kaleelconsult.com">
                                    <h4>info@kaleelconsult.com</h4>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".9s">
                        <div class="contact-info-item">
                            <div class="icon">
                                <i class="fa-solid fa-location-dot" aria-hidden="true"></i>
                            </div>
                            <div class="content">
                                <span>Office Address</span>
                                <h4>8 Yakubu Pam Crescent, Kado, Abuja</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ht contact info area -->

    <!-- ht contact form area -->
    <section class="ht-contact-form-area section-padding">
        <div class="container">
            <div class="section-title text-center">
                <span class="subtitle wow fadeInUp" data-wow-delay=".2s">Contact Us</span>
                <h2 class="title wow fadeInUp text-black" data-wow-delay=".5s">Have questions? <br>
                    contact us!</h2>
            </div>
            <div class="ht-contact-wrapper">
                <form action="" method="post">
                    <?php if (!empty($contact_success)): ?>
                        <div class="alert alert-success" role="alert"><?php echo htmlspecialchars($contact_success); ?></div>
                    <?php endif; ?>
                    <?php if (!empty($contact_errors)): ?>
                        <div class="alert alert-danger" role="alert">
                            <ul class="mb-0">
                                <?php foreach ($contact_errors as $err): ?>
                                    <li><?php echo htmlspecialchars($err); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" name="name" placeholder="Your name" required value="<?php echo htmlspecialchars($name ?? ''); ?>">
                                </div>
                                <div class="col-md-6">
                                    <input type="email" name="email" placeholder="Email address" required value="<?php echo htmlspecialchars($email ?? ''); ?>">
                                </div>
                                <div class="col-12">
                                    <input type="text" name="subject" placeholder="Select subject" required value="<?php echo htmlspecialchars($subject ?? ''); ?>">
                                </div>
                                <div class="col-12">
                                    <textarea name="message" placeholder="Type your message" required><?php echo htmlspecialchars($message ?? ''); ?></textarea>
                                </div>
                                <div class="col-12 text-center">
                                    <button type="submit" class="ht-btn style-2">SEND MESSAGE HERE</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
    <!-- ht contact form area -->

    <!-- ht map area start -->
    <div class="ht-map-area">
        <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d29187.55100927148!2d90.4212538!3d23.8738739!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c43b23589ec9%3A0x3f71bf01a9cd40de!2sBNS%20Center!5e0!3m2!1sen!2sbd!4v1760704093362!5m2!1sen!2sbd"
            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
        </iframe>
    </div>
    <!-- ht map area end -->

    <!-- ht-footer-area-start -->
    <?php include_once('includes/footer.php'); ?>
    <!-- ht-footer-area-end -->

    <?php include_once('includes/scripts.php'); ?>
</body>


<!-- Mirrored from prozen.vercel.app/contact.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 24 Nov 2025 11:52:14 GMT -->
</html>